package gov.va.med.mhv.util.client;

import gov.va.med.mhv.util.distributor.Distributor;
import gov.va.med.mhv.util.distributor.DistributorException;
import gov.va.med.mhv.util.distributor.HttpClientDistributor;
import gov.va.med.mhv.util.distributor.http.HTTPMethod;
import gov.va.med.mhv.util.distributor.message.BaseResponse;
import gov.va.med.mhv.util.distributor.message.HTTPRequestBean;
import gov.va.med.mhv.util.distributor.message.HTTPResponseBean;
import gov.va.med.mhv.util.distributor.message.MimeType;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Class that will initialize the Distributor to send a message to
 * the specified URI
 *
 */
public class SimpleSender {

	private static Logger logger = Logger.getLogger(SimpleSender.class.getName());

	/**
	 * Method that is used to send a message to an HTTP endpoint
	 * @param m
	 * @param mime
	 * @param address
	 * @param body
	 * @param httpProps
	 * @return
	 */
	public static HTTPResponseBean send(HTTPMethod m, MimeType mime, String address, String body, Map<String,String> httpProps){

		HTTPRequestBean request = new HTTPRequestBean();

		request.setHttpMethod(m);
		request.setUri(address);
		request.setBody(body);
		request.setMimeType(mime);
		request.setTimeout(10000);
		request.setProperties(httpProps);

		try {
			HttpClientDistributor d = new HttpClientDistributor(request);
			return d.distribute();

		} catch (DistributorException e) {
			logger.log(Level.SEVERE,"Error Sending Request Message", e);
		}
		return null;
	}
}
